function init_audio_form(){
    $("#audio_upload_form input[name='csrfmiddlewaretoken']").val(csrf_token);
    $('#audio_upload_form').ajaxForm({
        beforeSend: function(){
            $("#result").html("<div id='ajax-loader'></div>");
        },
        success: function(data){
            $("#result").html(data);
            init_audio_form();
        }
    });
}

$(function(){
    $("#adminShowPrediction, #do_batch_upload").click(function(){
        var category_id = $("select[name='category_id']").val();
        if(category_id != sibling_category_id){
            var container = $("#sphere_selects");
        } else {
            var container = $("#disc_selects");
        }
        var index1 = $("select[name='index1']", container).val();
        if($(this).attr('id') == 'adminShowPrediction'){
            var index2 = $("select[name='index2']", container).val();
            if(category_id && index1 && index2){
                $("#message").html("");
                $("#result").html("Загрузка");
                $("#buttons").html("");
                _data = {
                    category_id: category_id,
                    index1: index1,
                    index2: index2,
                    csrfmiddlewaretoken: csrf_token
                }
                $.ajax({
                    data: _data,
                    url: '/superadmin/post/',
                    beforeSend: function(){
                        $("#result").html("<div id='ajax-loader'></div>");
                    },
                    success: function(data, textStatus, jqXHR){
                        $("#result").html(data);
                        init_audio_form();
                    },
                    error: function(){
                        alert("Произошла ошибка. Попробуйте еще раз позже.");
                    },
                    type: 'POST'
                })
            } else {
                alert("Пожалуйста, выберите категорию, первый и второй индекс");
            }
        } else {
            var file = $('input[name="archive"]').val();
            if(!category_id){
                alert('Пожалуйста, выберите категорию для загрузки');
                return;
            }
            if(!index1){
                alert('Пожалуйста, выберите номер диска');
                return;
            }
            if(!file){
                alert('Пожалуйста, выберите файл архива для загрузки');
                return;
            }
            
            var data = {
                batch_index_1: index1,
                batch_upload: true
            }
            
            $('#adminPredictionForm').ajaxSubmit({
                data: data,
                success: function(data){
                    data = $.parseJSON(data);
                    
                    var batch_modal = $('#batch_result_modal');
                    $('.error_section', batch_modal).hide();
                    $('.success', batch_modal).html();
                    $('.errors', batch_modal).html();
                    
                    for(var key in data.success){
                        $('.success', batch_modal).append('<li>' + data.success[key] + '</li>');
                    }
                    if(data.errors.length){
                        $('.error_section', batch_modal).show();
                        
                        for(var key in data.errors){
                            $('.errors', batch_modal).append('<li>' + data.errors[key] + '</li>');
                        }
                    }
                    
                    $('input[type="file"]').val('');
                    batch_modal.dialog();
                },
                error: function(){
                    alert('Ошибка. Попробуйте повторить попытку позже.')
                }
            });
        }
    });
    $("select[name='category_id']").change(function(){
        if(($(this).val() == sibling_category_id && !$("#disc_selects").is(":visible")) ||
               $(this).val() != sibling_category_id && !$("#sphere_selects").is(":visible")){
           $("#disc_selects, #sphere_selects").toggle();
        }
    });
    
    $("select[name='upload_type']").change(function(){
        var disc_select_1 = $("#disc_selects span.selectbox:eq(1)");
        var disc_select_2 = $("#sphere_selects span.selectbox:eq(1)");
        var single_submit_button = $("#adminShowPrediction");
        var batch_form = $("#batch_upload_form");
        if($(this).val() == 'single'){
            disc_select_1.show();
            disc_select_2.show();
            single_submit_button.show();
            batch_form.hide();
            
        } else {
            disc_select_1.hide();
            disc_select_2.hide();
            single_submit_button.hide();
            batch_form.show();
        }
    })
})
